/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.base;

import filenet.vw.base.UserContextInfo;
import filenet.vw.base.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;

public class VWString {
    private static Logger logger = Logger.getLogger("filenet.vw.base");
    private static String m_className = VWString.class.getName();
    protected String key = null;
    protected String defaultString = null;
    protected Object[] args = null;
    public static Object synchObject = new Object();
    protected static Hashtable propBundleHashTable = new Hashtable(3);
    private static boolean warned = false;
    private static Locale resourceBundleLocale = null;
    public static final String CURRENT_HEBREW_CODE = "he";
    public static final String FORMER_HEBREW_CODE = "iw";
    public static final String NORWEGIAN_CODE = "nb";
    public static final String NORWEGIAN_LOCALE = "nb_NO";

    public static String _get_FILE_DATE() {
        return "$Date:   09 Sep 2008 01:12:42  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   qdang  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.25  $";
    }

    public VWString(String aKey, String engString) {
        this.key = aKey;
        this.defaultString = engString;
    }

    public VWString(String aKey, String engString, Object arg0) {
        this.key = aKey;
        this.defaultString = engString;
        this.args = new Object[1];
        this.args[0] = arg0;
    }

    public VWString(String aKey, String engString, Object arg0, Object arg1) {
        this.key = aKey;
        this.defaultString = engString;
        this.args = new Object[2];
        this.args[0] = arg0;
        this.args[1] = arg1;
    }

    public VWString(String aKey, String engString, Object arg0, Object arg1, Object arg2) {
        this.key = aKey;
        this.defaultString = engString;
        this.args = new Object[3];
        this.args[0] = arg0;
        this.args[1] = arg1;
        this.args[2] = arg2;
    }

    public VWString(String aKey, String engString, Object[] arguments) {
        this.key = aKey;
        this.defaultString = engString;
        this.args = arguments;
    }

    public String toString() {
        return this.toString(this.args);
    }

    public String toString(Object arg0) {
        Object[] args = new Object[]{arg0};
        return this.toString(args);
    }

    public String toString(Object arg0, Object arg1) {
        Object[] args = new Object[]{arg0, arg1};
        return this.toString(args);
    }

    public String toString(Object arg0, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg0, arg1, arg2};
        return this.toString(args);
    }

    public String toString(Object[] args) {
        String result = null;
        try {
            PropertyResourceBundle prb = VWString.getResourceBundle(this.getClass());
            result = prb.getString(this.key);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (result == null) {
                result = this.defaultString;
            }
            return MessageFormat.format(result, args);
        }
        catch (Exception exception) {
            return this.defaultString;
        }
    }

    public String getKey() {
        return this.key;
    }

    public static String getStringFromKey(String theKey) {
        String result = null;
        try {
            PropertyResourceBundle prb = VWString.getResourceBundle(VWString.class);
            result = prb.getString(theKey);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            result = "";
        }
        return result;
    }

    public static Locale getResourceBundleLocale() {
        return resourceBundleLocale;
    }

    private static String getKeyName(Class theClass, Locale theLocale) {
        return theLocale.toString() + ":" + theClass.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PropertyResourceBundle getResourceBundle(Class theClass) throws IOException {
        if (theClass == null) {
            return null;
        }
        Object object = synchObject;
        synchronized (object) {
            UserContextInfo userContext = UserContextInfo.get();
            Locale locale = userContext == null ? Locale.getDefault() : userContext.getLocale();
            String key = VWString.getKeyName(theClass, locale);
            PropertyResourceBundle prb = (PropertyResourceBundle)propBundleHashTable.get(key);
            boolean fromVWString = false;
            if (prb == null) {
                URL choice = VWString.getResourceURL(theClass, locale);
                if (choice == null && theClass != VWString.class && (prb = (PropertyResourceBundle)propBundleHashTable.get(VWString.getKeyName(VWString.class, locale))) == null) {
                    choice = VWString.getResourceURL(VWString.class, locale);
                    fromVWString = true;
                }
                if (choice != null) {
                    InputStream in = null;
                    try {
                        in = choice.openStream();
                        prb = new PropertyResourceBundle(in);
                        propBundleHashTable.put(key, prb);
                        if (fromVWString) {
                            propBundleHashTable.put(VWString.getKeyName(VWString.class, locale), prb);
                        }
                    }
                    catch (Exception e) {
                    }
                    finally {
                        try {
                            if (in != null) {
                                in.close();
                            }
                            in = null;
                        }
                        catch (Exception ex) {}
                    }
                }
            }
            return prb;
        }
    }

    private static URL getResourceURL(Class thisClass, Locale locale) {
        URL choice;
        String method = "getResourceURL";
        String userLang = locale.getLanguage();
        if (logger.isFinest()) {
            logger.finest(m_className, method, "[INFO] " + thisClass.getName() + ":  Locale= " + locale + " Locale language= " + userLang + ", Locale country= " + locale.getCountry());
        }
        if (userLang != null && userLang.equalsIgnoreCase(FORMER_HEBREW_CODE)) {
            userLang = CURRENT_HEBREW_CODE;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, method, "[INFO] " + thisClass.getName() + ":  Try to find resource file= " + "VWStrings_" + userLang + "_" + locale.getCountry());
        }
        if ((choice = VWString.tryResourceURL(thisClass, "VWStrings_" + userLang + "_" + locale.getCountry())) != null) {
            resourceBundleLocale = locale;
            return choice;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, method, "[WARNING] " + thisClass.getName() + ":  Cannot find resource file= " + "VWStrings_" + userLang + "_" + locale.getCountry());
        }
        if (userLang != null && userLang.equalsIgnoreCase(NORWEGIAN_CODE) || userLang != null && userLang.equalsIgnoreCase("NO")) {
            if (logger.isFinest()) {
                logger.finest(m_className, method, "[INFO] " + thisClass.getName() + ":  Try to find resource file= " + "VWStrings_" + NORWEGIAN_LOCALE);
            }
            if ((choice = VWString.tryResourceURL(thisClass, "VWStrings_nb_NO")) == null && logger.isFinest()) {
                logger.finest(m_className, method, "[WARNING] " + thisClass.getName() + ":  Cannot find resource file= " + "VWStrings_" + NORWEGIAN_LOCALE);
            }
        } else {
            if (logger.isFinest()) {
                logger.finest(m_className, method, "[INFO] " + thisClass.getName() + ":  Try to find resource file= " + "VWStrings_" + userLang);
            }
            if ((choice = VWString.tryResourceURL(thisClass, "VWStrings_" + userLang)) == null && logger.isFinest()) {
                logger.finest(m_className, method, "[WARNING] " + thisClass.getName() + ":  Cannot find resource file= " + "VWStrings_" + userLang);
            }
        }
        if (choice != null) {
            resourceBundleLocale = locale;
            return choice;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, method, "[INFO] " + thisClass.getName() + ":  Try to find resource file= " + "VWStrings_en_US");
        }
        if ((choice = VWString.tryResourceURL(thisClass, "VWStrings_en_US")) != null) {
            resourceBundleLocale = new Locale("en", "US");
            return choice;
        }
        if (!warned) {
            logger.fine(m_className, method, "[WARNING] " + thisClass.getName() + ":  Could not find resource file! Locale=" + locale);
            warned = true;
        }
        return null;
    }

    protected static URL tryResourceURL(Class thisClass, String resourceURL) {
        String method = "tryResourceURL";
        URL choice = thisClass.getResource(resourceURL);
        if (choice != null) {
            logger.fine(m_className, method, "Resource file for " + thisClass.getName() + " = " + choice.toString());
            return choice;
        }
        return null;
    }
}

